function test_suite = testRdivide %#ok<STOUT>
initTestSuite;

function testZeroDividedByReal %#ok<*DEFNU>
x = polysym(0);
y = polysym(rand);
z = x./y;
assertTrue(z.Value=='0');

function testZeroDividedByChar
x = polysym(0);
y = polysym('y');
z = x./y;
assertTrue(z.Value=='0');

function testZeroDividedByZero
x = polysym(0);
f = @() x./0;
assertExceptionThrown(f,'polysym:rdivide:DivideByZero')

function testCharDividedByZero
x = polysym('x');
f = @() x./0;
assertExceptionThrown(f,'polysym:rdivide:DivideByZero')

function testCharDividedByInteger
x = polysym('x');
z = x./5;
assertEqual(z.Value,'x/5');

function testCharDividedByReal
x = polysym('x');
y = polysym(pi);
z = x./y;
assertEqual(z.Value,['x/',y.Value]);

function testRealDividedByChar
x = polysym(pi);
y = polysym('y');
z = x./y;
assertEqual(z.Value,[x.Value,'/y']);

function testScalarDividedByVector
x = polysym('x');
y = polysym(1:3);
z = x./y;
assertEqual(z(1).Value,'x');
assertEqual(z(2).Value,'x/2');
assertEqual(z(3).Value,'x/3');

function testVectorDividedByVector
x = polysym({'x','y'});
y = polysym({'u','w'});
z = x./y;
assertEqual(z(1).Value,'x/u');
assertEqual(z(2).Value,'y/w');

function testDivDiv
% NOTE: This result is undesirable.
x = polysym('x');
y = polysym('4/y');
z = x./y;
assertEqual(z.Value,'x/4/y');
